#include "App.h"

const float wpw = 20;
const float wph = 20;
const float mapw = 20;
const float maph = 20;

Texture *cursorTex;

ConfigManager *config;

int edited_hmap_x = 0;
bool paused = false;
bool show_credits = false;
bool show_instructions = false;

bool p_at_right[2] = { false, true };

float gravity;

void App::onInit() {

   glEnable(GL_COLOR_MATERIAL);
   glDisable(GL_LIGHTING);
   glEnable(GL_TEXTURE_2D);
   glEnable(GL_NORMALIZE);
   glFrontFace(GL_CCW);
   glClearColor(0.2f,0.4f,0.6f,0.0f);  // blue sunny
   //glClearColor(0.7f,0.7f,0.7f,0.0f);   // foggy
   glClearStencil(0);
   glEnable(GL_STENCIL_TEST);
   glDisable(GL_DEPTH_TEST);

   srand(time(NULL));
   
   tman = TerrainManager::instance();
   
   //tman->initFromFile("data/default.map");
   //tman->initRandom(0,20,5,5,5.0f,4);
   tman->initFromDirectory();
   
   effman = EffectsManager::instance();
   effman->init();

   player[0].init();
   player[0].setId(0);
   player[1].init();
   player[1].setId(1);
   player[0].setPos(-1,-1);
   player[1].setPos(-1,-1);
   winner = NULL;

   for (int i=0;i<2;++i) {
      up_pressed[i] = down_pressed[i] = left_pressed[i] = right_pressed[i] = fire_pressed[i] = 0;
   }
   p1_up_time = p2_up_time = 0;

   cursorTex = new Texture("data/cursor.png");
   cursorTex->build();

   lifebar[0] = new Texture("data/blue_lifebar.png");
   lifebar[1] = new Texture("data/red_lifebar.png");
   lifebar[0]->build();
   lifebar[1]->build();

   panel[0] = new Texture("data/blue_panel.png");
   panel[1] = new Texture("data/red_panel.png");
   panel[0]->build();
   panel[1]->build();

   circle = new Texture("data/circle.tga");
   circle->build();

   logo = new Texture("data/logo.png");
   logo->build();

   emptylifebar = new Texture("data/empty_lifebar.png");
   emptylifebar->build();

   pointerx = 1;
   pointery = 1;

   setupUI();
   chat_mode = false;
   memset(incomingChat[0],0,256);
   memset(incomingChat[1],0,256);

   setState(GS_MENU);
   
   //SDL_WM_GrabInput(SDL_GRAB_ON);
   //SDL_ShowCursor(0);

   initQuotes();
   
   sound.init();
   sound.playMetallica();
   
   timet = 0;
   timer.start();

   paused = true;
}


void App :: setupUI() {

   iman = InterfaceManager::instance();
   iman->init(this);

   iman->setAmmo(player[0].getAmmo(),player[1].getAmmo());

   iman->setMapName(tman->getCurrentMapFile());
   
   //debugMessage("(h) host a game, (c) connect to a game");
   debugMessage("OldUr 0.2  -  nightshift'06");

}

void App::onRender() {

   static double dLastElapsed;
   dElapsed = timer.elapsed();
   
   if (!paused)
      timet += dElapsed;

   timer.start();

   glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT | GL_STENCIL_BUFFER_BIT);
   glLoadIdentity();
   //glScalef(0.5f,1.0f,1);

   renderTerrain(0,0);
   //renderTerrain(camera_shiftx2,10);

   if (!paused) {
      player[0].update(dElapsed);
      player[1].update(dElapsed);
   }
   glDisable(GL_TEXTURE_2D);
   player[0].render(0,0,1);
   player[1].render(1,0,0);

   glStencilFunc(GL_EQUAL, 1, 0xffffffff);
   glStencilOp(GL_KEEP, GL_KEEP, GL_KEEP);	
   glEnable(GL_TEXTURE_2D);
   glEnable(GL_STENCIL_TEST);
   glColor3f(1,1,1);
   effman->updatePlayerPositions(player[0].getPosX(),player[0].getPosY(),player[1].getPosX(),player[1].getPosY());
   effman->update(dElapsed);
   effman->render();
   glDisable(GL_STENCIL_TEST);
   
   // update and render projectiles
   ProjList::iterator pi = projectiles.begin();
   while (pi != projectiles.end()) {
      Projectile *proj = *pi;
      proj->update(dElapsed);
      proj->render();

      int eid = proj->getTrailEffectId();
      if (eid!=-1)
         effman->setEmitterPos(eid,proj->getPosX(),proj->getPosY());

      ++pi;
   }

   // update and render bonus objects
   BonusList::iterator bi = bonuses.begin();
   while (bi != bonuses.end()) {
      Bonus *bonus = *bi;
      bonus->update(dElapsed);
      
      float bx = bonus->getX();
      float ty = tman->getHot(bx);
      if (ty > bonus->getY()) {
         bonus->setPos(bx,ty);
         bonus->endJump();
      }
      
      bonus->render();

      ++bi;
   }


   //debugMessage("%.1f",player[0].getPosX());
   
   if (getState() == GS_PLAY && !paused) {

      spawnRandomBonus();
      
      if (left_pressed[0] || right_pressed[0]) {
         
         movePlayer(&player[0],1.1f * player[0].getSpeed() * dElapsed * 0.2f * (left_pressed[0]?-1:1));
         player[0].runAnimation(2);
      }
      else {
         if (player[0].isJumping() == false)
            player[0].runAnimation(0);

         // a hack to handle exit-from-jump-situation correctly
         movePlayer(&player[0],0);
      }

      if (left_pressed[1] || right_pressed[1]) {
         movePlayer(&player[1],1.1f * player[1].getSpeed() * dElapsed * 0.2f * (left_pressed[1]?-1:1));
         player[1].runAnimation(2);
         
         // a hack to handle exit-from-jump-situation correctly
         movePlayer(&player[1],0);
      }
      else {
         if (player[1].isJumping() == false)
            player[1].runAnimation(0);

         // a hack to handle exit-from-jump-situation correctly
         movePlayer(&player[1],0);
      }
      
      if (up_pressed[0] || down_pressed[0]) {
         turnTurret(&player[0],up_pressed[0]?1:-1);
      }
      if (up_pressed[1] || down_pressed[1]) {
         turnTurret(&player[1],up_pressed[1]?1:-1);
      }
      if (fire_pressed[0]) {
         if (player[0].canFireWeapon())
            player[0].setThrowForce(player[0].getThrowForce()+dElapsed);
      }
      else {
         player[0].setThrowForce(player[0].getThrowForce()-dElapsed);
      }
      if (fire_pressed[1]) {
         if (player[1].canFireWeapon())
            player[1].setThrowForce(player[1].getThrowForce()+dElapsed);
      }
      else {
         player[1].setThrowForce(player[1].getThrowForce()-dElapsed);
      }


      // check projectile-terrain & projectile-player collisions
      ProjList::iterator pii = projectiles.begin();
      while (pii != projectiles.end()) {
      
         Projectile *proj = *pii;
      
         //projectile-player
         //only host decides if a projectile hits or misses
         if ( 1 ) {
            Player *targetplayer;
            if (proj->getPlayer() == 1)
               targetplayer = &player[0];
            else
               targetplayer = &player[1];
            if (targetplayer) {
               if (targetplayer->checkCollision(proj->getPosX(),proj->getPosY(),proj->getR())) {
                  targetplayer->setEnergy(targetplayer->getEnergy()-1);
                  effman->createExplosionDecal(targetplayer->getPosX(),targetplayer->getPosY(),0.3f);
                  
                  effman->setPlayerDamageEffect(targetplayer->getId(),/*10-targetplayer->getEnergy()*/3);
                  effman->makePlayerExplosion(targetplayer->getId());

                  effman->createBloodSplat(targetplayer->getPosX(),targetplayer->getPosY(),0.1f);
                  //effman->createBloodSplat(x ,hot - 0.3f ,0.1f);
               
                  if (targetplayer->getPosX() > proj->getPosX())
                     targetplayer->beginJump(2.0f,8.0f);
                  else
                     targetplayer->beginJump(-2.0f,8.0f);

                  if (targetplayer == &player[0])                  
                     player[1].setScore(player[1].getScore()+1);
                  else
                     player[0].setScore(player[0].getScore());

                  iman->updateScores(player[0].getScore(),player[1].getScore());
                  ProjList::iterator pii_curr = pii;
                  ++pii;
                  
                  Projectile *proj = *pii_curr;
                  if (proj->getTrailEffectId() != -1)
                     effman->removeEmitterByTime(proj->getTrailEffectId(),3.0f);

                  projectiles.erase(pii_curr);
                  delete proj;

                  sound.playExplosionSound();
                  sound.playDeathSound();

                  continue;
               }
            }
         }
      
         // projectile-terrain
         float x = proj->getPosX();
         float hot = tman->getHot(x);
         if (proj->getPosY() < hot) {  // collision
            proj->setPos(x,hot);
            //proj->zeroForce();
            //proj->setSpeed(0);
            effman->createExplosionDecal(x,hot,0.2f);
            effman->makeExplosion(x,hot);
            
            ProjList::iterator pii_curr = pii;
            ++pii;

            Projectile *proj = *pii_curr;
            if (proj->getTrailEffectId() != -1)
               effman->removeEmitterByTime(proj->getTrailEffectId(),3.0f);

            projectiles.erase(pii_curr);
            delete proj;

            sound.playExplosionSound();

            continue;
         }
      
         ++pii;
      }

      if (player[0].getEnergy() < 0 || player[1].getEnergy()<0) {

         if (getState() == GS_PLAY) {

            if (player[0].getEnergy() < 0) {
               winner = &player[1];
               player[0].runAnimation(14);   // eyo! (continuous)
               player[1].runAnimation(14);   // eyo! (continuous)
            }
            else {
               winner = &player[0];
               player[1].runAnimation(14);   // eyo! (continuous)
               player[0].runAnimation(14);   // eyo! (continuous)
            }

            setState(GS_GAMEOVER);
            
            sound.playCheersSound();

            debugMessage("BRAVO!! super oldurdun!!!");

            say(winner->getId(),"eyooooo!!! oldurdum!");
            say(1-winner->getId(),"aarrrgggghh!");
         
         }
        
         
      }

      // check bonus - player collisions
      BonusList::iterator bi = bonuses.begin();
      while (bi != bonuses.end()) {
      
         Bonus *bonus = *bi;

         for (int pid = 0;pid<2;++pid) {
         
            if (player[pid].checkCollision(bonus->getX(),bonus->getY(),0.2f)) {
            
               if (bonus->getType() == BT_HEALTH)
                  player[pid].setEnergy(player[pid].getEnergy()+1);
               else
               if (bonus->getType() == BT_AMMO) {
                  player[pid].setAmmo(player[pid].getAmmo()+1);
                  iman->setAmmo(player[0].getAmmo(),player[1].getAmmo());
               }

               BonusList::iterator bi_curr = bi;
               ++bi;

               bonuses.erase(bi_curr);
               delete bonus;
               
               --bi;

               sound.playBonusCaptureSound();

            }
         
         }

      
         ++bi;
      }


   }
   else
   if (getState() == GS_GAMEOVER) {

      int yon = (rand()%2) == 0 ? 1 : -1;
      
      if (winner->isJumping() == false) {
         
         winner->beginJump(yon * 0.3f,4.0f);
         
         sound.playJumpSound();

      }

      movePlayer(winner,0);

   }

   if (getState() == GS_LISTEN) {
      static float timeout = 1.0f;
      timeout -= dElapsed;
      if (timeout < 0) {
         timeout = 1.0f;
      }
   }
   
   renderCPanel();

   iman->updateChatMessages(player[0].getPosX(),player[0].getPosY(),
      incomingChat[0],player[1].getPosX(),player[1].getPosY()-0.5f,incomingChat[1]);
   iman->update(dElapsed);
   iman->render();

      
}

void App :: renderTerrain(float shiftx,float shifty) {
      
   glTranslatef(shiftx,shifty,0);
   
   // render terrain
   glDisable(GL_LIGHTING);
   glColor3f(1,1,1);
   tman->render();
      
}

void App :: renderCPanel() {

   glEnable(GL_BLEND);
   glBlendFunc(GL_ONE,GL_ONE_MINUS_SRC_ALPHA);
   
   glPushMatrix();
   
   float sx,sy;
   
   for (int i=0;i<2;++i) {
   
      sx=0.4f;
      sy=0.4f;
      
      glColor3f(1,1,1);
      
      if (i==1)
         glTranslatef(16.8f,0,0);   

      panel[i]->begin();
      glBegin(GL_QUADS);
      glTexCoord2f(0,0); glVertex2f(0.2f,0.2f);
      glTexCoord2f(1-0.01f,0); glVertex2f(4,0.2f);
      glTexCoord2f(1-0.01f,1-0.01f); glVertex2f(4,4);
      glTexCoord2f(0,1-0.01f); glVertex2f(0.2f,4);
      glEnd();
      panel[i]->end();
      
      glPushMatrix();
      glTranslatef(0.4f,0.4f,0);

      emptylifebar->begin();
      glBegin(GL_QUADS);
      glTexCoord2f(0,0); glVertex2f(0.2f*sx,0.2f*sy);
      glTexCoord2f(1,0); glVertex2f(4*sx,0.2f*sy);
      glTexCoord2f(1,1); glVertex2f(4*sx,4*sy);
      glTexCoord2f(0,1); glVertex2f(0.2f*sx,4*sy);
      glEnd();
      emptylifebar->end();
      
      float energyy = 0.1f * player[i].getEnergy();
      
      lifebar[i]->begin();
      glBegin(GL_QUADS);
      glTexCoord2f(0,0); glVertex2f(0.2f*sx,0.2f*sy);
      glTexCoord2f(1,0); glVertex2f(4*sx,0.2f*sy);
      glTexCoord2f(1,energyy); glVertex2f(4*sx,4*sy*energyy);
      glTexCoord2f(0,energyy); glVertex2f(0.2f*sx,4*sy*energyy);
      glEnd();
      lifebar[i]->end();
      
      glTranslatef(1.0f,0,0);

      sx = 0.2f;
      sy = 0.2f;

      if (i==0)
         glColor3f(0.6f,0.6f,1);
      else
         glColor3f(1,0.3f,0.3f);
      
      circle->begin();
      glBegin(GL_QUADS);
      glTexCoord2f(0,0); glVertex2f(0.2f*sx,0.2f*sy);
      glTexCoord2f(1,0); glVertex2f(4*sx,0.2f*sy);
      glTexCoord2f(1,1); glVertex2f(4*sx,4*sy);
      glTexCoord2f(0,1); glVertex2f(0.2f*sx,4*sy);
      glEnd();
      circle->end();     
      
      glPopMatrix();



   }   
 
   glPopMatrix();   
   
   sx = 5;
   sy = 5;
   
   static float t=0;
   t += dElapsed;
   
   if (getState() == GS_PLAY)
      glColor4f(0.3f,0.3f,0.3f,0.5f);
   else
      glColor4f(0.3f + sinf(t),0.3f,0.3f,0.5f);
   
   glTranslatef(8.5f - 0.1f,13.0f,0);
   
   if (iman->isMenuVisible()) {
   
      logo->begin();
      glBegin(GL_QUADS);
      glTexCoord2f(0,0); glVertex2f(0*sx,0*sy);
      glTexCoord2f(1,0); glVertex2f(1*sx,0*sy);
      glTexCoord2f(1,0.8f); glVertex2f(1*sx,1*sy);
      glTexCoord2f(0,0.8f); glVertex2f(0*sx,1*sy);
      glEnd();
      logo->end();

   }

      
   glDisable(GL_BLEND);


}

void App :: onKeyPressed(const SDLKey &key) {

   iman->processKeyEvents(key);

   if (key == SDLK_ESCAPE && (show_credits || show_instructions)) {
      show_credits = false;
      show_instructions = false;
      iman->showCreditsPanel(false);
      iman->showInstPanel(false);
      iman->activateMainMenu(true);
      return;
   }
   
   if (chat_mode == true && key != SDLK_ESCAPE)
      return;
   
   static int efflevel=0;

   switch (key) {

         case SDLK_ESCAPE:
            iman->toggleMainMenu();
            if (iman->isMenuVisible()) {
               paused = true;
               sound.playJumpSound();
            }
            else
               paused = false;
            break;

         case p1_up:
            if (getState() != GS_GAMEOVER) {
               up_pressed[0] = true;
               if (timet - p1_up_time < UP_TIME_THRESHOLD) {
               
                  up_pressed[0] = false;
                  //turnTurret(&player[0],up_pressed[0]?1:-1);
               
                  if (player[0].isfaceToRight())
                     player[0].beginJump(0.5f,5.0f);
                  else
                     player[0].beginJump(-0.5f,5.0f);
                  player[0].runAnimation(2);
                  sound.playJumpSound();
               }
               p1_up_time = timet;
            }
            break;

         case p1_down:
            down_pressed[0] = true;
            break;

         case p1_left:
            left_pressed[0] = true;
            /*
            if (player[0].isfaceToRight() == true)
               player[0].setTurretAngle(180-player[0].getTurretAngle());
            player[0].faceToRight(false);           
            */
            break;
         case p1_right:
            right_pressed[0] = true;
            /*
            if (player[0].isfaceToRight() == false)
               player[0].setTurretAngle(180-player[0].getTurretAngle());
            player[0].faceToRight(true);
            */
            break;

         case p1_fire:
            fire_pressed[0] = true;
            break;

         case p2_up:
            if (getState() != GS_GAMEOVER) {
               up_pressed[1] = true;
               if (timet - p2_up_time < UP_TIME_THRESHOLD) {
               
                  //turnTurret(&player[1],up_pressed[1]?1:-1);
                  up_pressed[1] = false;
               
                  if (player[1].isfaceToRight())
                     player[1].beginJump(0.5f,5.0f);
                  else
                     player[1].beginJump(-0.5f,5.0f);
                  player[1].runAnimation(2);
                  sound.playJumpSound();
               }
               p2_up_time = timet;
            }
            break;

         case p2_down:
            down_pressed[1] = true;
            break;

         case p2_left:
            left_pressed[1] = true;
            /*
            if (player[1].isfaceToRight() == true)
               player[1].setTurretAngle(180-player[1].getTurretAngle());
            player[1].faceToRight(false);
            */
            break;

         case p2_right:
            right_pressed[1] = true;
            /*
            if (player[1].isfaceToRight() == false)
               player[1].setTurretAngle(180-player[1].getTurretAngle());
            player[1].faceToRight(true);
            */
            break;

         case p2_fire:
            fire_pressed[1] = true;
            break;

         case SDLK_q:
            spawnRandomBonus();
            break;

         case SDLK_1:
            if (--edited_hmap_x < 0)
               edited_hmap_x = 0;
            break;

         case SDLK_2:
            if (++edited_hmap_x > 20)
               edited_hmap_x = 20;
            break;

         case SDLK_KP_PLUS:
            tman->setHeight(edited_hmap_x,tman->getHot(edited_hmap_x)+0.1f);
            break;

         case SDLK_KP_MINUS:
            tman->setHeight(edited_hmap_x,tman->getHot(edited_hmap_x)-0.1f);
            break;

         case SDLK_3:
            {
               static int anum = 0;
               player[0].runAnimation(anum++);
            }
            break;


      }

}

void App :: onKeyReleased(const SDLKey &key) {
   
   if (chat_mode)
      return;
   
   switch (key) {
      case p1_left:
         left_pressed[0] = false;
         break;
      case p1_right:
         right_pressed[0] = false;
         break;
      case p1_up:
         up_pressed[0] = false;
         break;
      case p1_down:
         down_pressed[0] = false;
         break;
      case p1_fire:
         fire_pressed[0] = false;
         if (player[0].canFireWeapon() && !paused) {
            launchProjectile(&player[0],cos(DToR(player[0].getTurretAngle())),sin(DToR(player[0].getTurretAngle())));
         }
         break;
      case p2_up:
         up_pressed[1] = false;
         break;
      case p2_down:
         down_pressed[1] = false;
         break;
      case p2_left:
         left_pressed[1] = false;
         break;
      case p2_right:
         right_pressed[1] = false;
         break;
      case p2_fire:
         fire_pressed[1] = false;
         if (player[1].canFireWeapon() && !paused) {
            launchProjectile(&player[1],cos(DToR(player[1].getTurretAngle())),sin(DToR(player[1].getTurretAngle())));
         }
         break;



   }
}

void App :: UIEvent_Callback(UIEvent *event) {

   UIWidget *source = event->source;
   if (iman->isChatInputEdit(source)) {
      if (event->type == UIEvent::UIEVT_UIEDIT_ENTERPRESSED) {
         chat_mode = false;
         iman->endChatText();
         const char *text = iman->getChatText();
         strcpy(incomingChat[0],text);
      }
   }
   else
   if (iman->isMainMenu(source)) {

      sound.playJumpSound();

      if (event->type == UIEvent::UIEVT_UIMENU_ITEMSELECTED) {
         int item = event->data;
         switch (item) {
            
            case 0:
               gravity = -0.9f;
               
               setState(GS_PLAY);
               
               iman->activateMainMenu(false);
               
               startGame();

               sound.playBuzzerSound();
               
               debugMessage("oyun basladi! buyrun oldurun...");

               randomQuote();

               break;

            case 1:

               gravity = -0.1f;

               setState(GS_PLAY);
               
               iman->activateMainMenu(false);
               
               startGame();

               sound.playBuzzerSound();
               
               debugMessage("oyun basladi! buyrun oldurun...");

               randomQuote();

               break;

            case 2:
               changeMap();
               break;

            case 3:
               
               iman->showInstPanel(true);
               show_instructions = true;
               break;
               
            case 4:               
               iman->showCreditsPanel(true);
               show_credits = true;
               break;
               
            case 5:               
               exit();
               break;
               
         };
      }
   }
   else
   if (iman->isIpEdit(source)) {
      if (event->type == UIEvent::UIEVT_UIEDIT_ENTERPRESSED) {
         iman->showIpPanel(false);
         iman->activateMainMenu(false);
      }
      else
      if (event->type == UIEvent::UIEVT_UIEDIT_ESCPRESSED) {
         iman->showIpPanel(false);
         iman->activateMainMenu(true);
      }
   }

}

void App :: onMouseButtonPressed(int button,int scrx,int scry) {

}

void App :: movePlayer(Player *p,float dist) {

   float wx[WHEEL_COUNT],wy[WHEEL_COUNT];
   
   dist *= 3.0f;

   float px = p->getPosX() + dist;

   float ty = tman->getHot(px);
   if (p->isJumping()) {
      if (p->getPosY() >= ty) {
         ty = p->getPosY();
      }
      else {
         p->endJump();
         effman->setPlayerDamageEffect(p->getId(),0);  // stop effect
      }
   }

   if (px > mapw) px = mapw - 0.01f;
   if (px < 0.05f)    px = 0.05f;
   
   p->setPos(px,ty);
   p->setWheelPosAgainstCenter();
   
   p->getWheelPos(wx,wy);
   for (int i=0;i<WHEEL_COUNT;++i) {      
      wy[i] = tman->getHot(wx[i]);   
   }
   p->setWheelPos(wx,wy);

   float adist = fabs(dist);
   p->setSteerEnergy(p->getSteerEnergy()-adist);

   if (p->getPosX() > player[1-p->getId()].getPosX()) {
      
      if (p_at_right[p->getId()] == false) {
         p->setTurretAngle(180-p->getTurretAngle());         
      }

      p->faceToRight(false);
      p_at_right[p->getId()] = true;
   }
   else {
      
      if (p_at_right[p->getId()] == true) {
         p->setTurretAngle(180-p->getTurretAngle());
      }
      
      p->faceToRight(true);
      p_at_right[p->getId()] = false;
   }


}

void App :: turnTurret(Player *p,float dir) {

   if (p->isfaceToRight()) {
      p->turnTurret(200*dElapsed*dir);
      float ta = p->getTurretAngle();
      if (ta > 90)  p->setTurretAngle(90.0f);
      if (ta < -90) p->setTurretAngle(-90.0f);
   }
   else {
      p->turnTurret(200*dElapsed*(-dir));
      float ta = p->getTurretAngle();
      if (ta > 270) p->setTurretAngle(270.0f);
      if (ta < 90)  p->setTurretAngle(90.0f);
   }

}

void App :: launchProjectile(Player *p,float dx,float dy) {
   
   Projectile *proj = new Projectile;
   proj->setPlayer(p->getId());
   proj->setPos(p->getPosX(),p->getPosY()+0.3f);
   proj->setVelocity(dx*p->getThrowForce(),dy*p->getThrowForce());
   proj->setGravity(0,gravity);
   proj->launch();

   p->weaponFired();
   p->setAmmo(p->getAmmo()-1);
   iman->setAmmo(player[0].getAmmo(),player[1].getAmmo());

   int eid = effman->createMissileTrail(p->getPosX(),p->getPosY());
   proj->setTrailEffectId(eid);
      
   projectiles.push_back(proj);

   sound.playFireSound();

}

void App :: spawnRandomBonus() {

   static int lastBonus = -1;
   static double bonusSpawnTime = 0;
   
   if (timet - bonusSpawnTime < MIN_BONUS_SPAWN_TIME)
      return;
   
   bonusSpawnTime = timet;

   Bonus *bonus = NULL;
   do {
   
      if (bonus)
         delete bonus;

      bonus = new Bonus();
      bonus->randomize();

   } while (bonus->getType() == (eBonusType) lastBonus);

   lastBonus = (int) bonus->getType();

   float x = (rand()%1000) * 0.001 * mapw;
   bonus->setPos(x,tman->getHot(x) + 3.0f);
   bonus->beginJump(2.0f);

   bonuses.push_back(bonus);

   

}

void App :: say(int pid,const char *message) {
   strcpy(incomingChat[pid],message);
}

void App :: initQuotes() {
   
   FILE *fp = fopen("data/quotes.txt","rt");

   char line[256];
   while (fgets(line,256,fp)) {
      if (strlen(line) > 1) {
         line[strlen(line)-1] = '\0';
         quotes.push_back(line);
      }
   }

   fclose(fp);

}

void App :: randomQuote() {

   int r1 = rand()%quotes.size();
   int r2 = rand()%quotes.size();
   
   const char *s1 = quotes[r1].c_str();
   const char *s2 = quotes[r2].c_str();
   
   say(0,s1);
   say(1,s2);

}

void App :: changeMap() {
   tman->initNextMapFromDirectory();
   iman->setMapName(tman->getCurrentMapFile());

   player[0].setPos(player[0].getPosX(),tman->getHot(player[0].getPosX()));
   player[1].setPos(player[1].getPosX(),tman->getHot(player[1].getPosX()));
}

void App :: startGame() {

   int px = 1;
   
   player[0].reset();
   player[0].setPos(px,tman->getHot(px));
   player[0].setWheelPosAgainstCenter();
   player[0].faceToRight(true);
   player[0].runAnimation(2);
   player[0].turnTurret(0);
   
   player[1].reset();
   player[1].setPos(mapw-px,tman->getHot(mapw-px));
   player[1].setWheelPosAgainstCenter();
   player[1].runAnimation(2);
   player[1].faceToRight(false);
   player[1].turnTurret(180);

   player[0].beginJump(1.0f,4.0f);
   player[1].beginJump(-1.0f,4.0f);


   iman->setAmmo(player[0].getAmmo(),player[1].getAmmo());

   effman->reset();

   // delete bonuses
   BonusList::iterator bi = bonuses.begin();
   while (bi != bonuses.end()) {
      
     Bonus *bonus = *bi;
     BonusList::iterator bi_curr = bi;
     ++bi;

     bonuses.erase(bi_curr);
     delete bonus;
               
   }

   p_at_right[0] = false;
   p_at_right[1] = true;
   
   paused = false;

}

void App :: debugMessage(const char *format,...) {
   
   static char buffer[256];
   
   va_list args;
   va_start(args, format);
   vsprintf(buffer,format,args);

   iman->debugMessage(buffer);
}


//--------------------------------------------------------

int main(int argc,char **argv) {

   App app;

   config = ConfigManager::instance();
   
   app.winw = config->getScrw();
   app.winh = config->getScrh();
   
   app.setSize(app.winw,app.winh);
   app.setFullScreen(config->getFullscreen());
   app.showFPS(true);

   app.setProjection(PROJ_ORTHO);
   app.setOrthoParams(0,wpw,0,wph);

   app.start();

   return 0;
}